/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.inventory;

import com.technicalitiesmc.lib.container.item.ItemContainer;
import com.technicalitiesmc.lib.inventory.DroppedItemHandler;
import com.technicalitiesmc.lib.inventory.DroppingItemHandler;
import com.technicalitiesmc.lib.inventory.InventoryHint;
import com.technicalitiesmc.lib.inventory.InventoryHintFlags;
import com.technicalitiesmc.lib.inventory.ItemFilter;
import com.technicalitiesmc.lib.inventory.ItemHandlerExtractionQuery;
import com.technicalitiesmc.lib.inventory.ItemHandlerInsertionQuery;
import com.technicalitiesmc.lib.item.ItemPredicate;
import com.technicalitiesmc.lib.menu.EmptyMenu;
import java.util.PrimitiveIterator;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Contract;

public final class InventoryHelper {
    private static final Capability<IItemHandler> ITEM_HANDLER_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IItemHandler>(){});
    private static final Capability<ItemPredicate> ITEM_PREDICATE_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ItemPredicate>(){});
    private static final IItemHandler EMPTY = new ItemStackHandler(0);

    public static IItemHandler emptyItemHandler() {
        return EMPTY;
    }

    public static Iterable<Integer> find(IItemHandler inventory, Predicate<ItemStack> filter) {
        return () -> IntStream.range(0, inventory.getSlots()).filter(s -> filter.test(inventory.getStackInSlot(s))).iterator();
    }

    public static CraftingContainer createCraftingContainer(ItemContainer inventory, int offset) {
        CraftingContainer craftingContainer = new CraftingContainer((AbstractContainerMenu)new EmptyMenu(), 3, 3);
        for (int i = 0; i < 9; ++i) {
            craftingContainer.m_6836_(i, inventory.get(i + offset));
        }
        return craftingContainer;
    }

    public static boolean matchesFilter(ItemStack filter, ItemStack stack) {
        return InventoryHelper.matchesFilter(filter, stack, false);
    }

    public static boolean matchesFilter(ItemStack filter, ItemStack stack, boolean resultIfEmptyFilter) {
        if (filter.m_41619_()) {
            return resultIfEmptyFilter;
        }
        LazyOptional cap = filter.getCapability(ITEM_PREDICATE_CAPABILITY);
        if (cap.isPresent()) {
            return ((ItemPredicate)cap.orElse(null)).test(stack);
        }
        return ItemHandlerHelper.canItemStacksStack((ItemStack)filter, (ItemStack)stack);
    }

    @Nullable
    public static IItemHandler getNeighborItemHandler(Level level, BlockPos pos, Direction side) {
        return (IItemHandler)InventoryHelper.getNeighborItemHandlerLazy(level, pos, side).orElse(null);
    }

    public static LazyOptional<IItemHandler> getNeighborItemHandlerLazy(Level level, BlockPos pos, Direction side) {
        BlockEntity entity = level.m_7702_(pos.m_142300_(side));
        if (entity == null) {
            return LazyOptional.empty();
        }
        return entity.getCapability(ITEM_HANDLER_CAPABILITY, side.m_122424_());
    }

    @Nullable
    @Contract(value="_, _, _, _, true -> !null")
    public static IItemHandler getNeighborItemHandlerOrDropping(Level level, BlockPos pos, Direction side, int maxStacks, boolean dropIfOccluded) {
        IItemHandler neighbor;
        if (!(level.m_8055_(pos.m_142300_(side)).m_60795_() || (neighbor = InventoryHelper.getNeighborItemHandler(level, pos, side)) == null && dropIfOccluded)) {
            return neighbor;
        }
        return new DroppingItemHandler(level, pos, side, maxStacks);
    }

    @Nullable
    @Contract(value="_, _, _, _, true -> !null")
    public static IItemHandler getNeighborItemHandlerOrPickingUp(Level level, BlockPos pos, Direction side, AABB area, boolean pickUpIfOccluded) {
        IItemHandler neighbor;
        if (!(level.m_8055_(pos.m_142300_(side)).m_60795_() || (neighbor = InventoryHelper.getNeighborItemHandler(level, pos, side)) == null && pickUpIfOccluded)) {
            return neighbor;
        }
        return new DroppedItemHandler(level, area);
    }

    public static boolean transferStack(IItemHandler src, IItemHandler dst) {
        return InventoryHelper.transferStack(src, dst, ItemFilter.atMost(64).ofAnyItem());
    }

    public static boolean transferStack(IItemHandler src, IItemHandler dst, ItemFilter filter) {
        return InventoryHelper.transferStack(src, dst, filter, ItemHandlerExtractionQuery.defaultVisitOrder(src.getSlots()));
    }

    public static boolean transferStack(IItemHandler src, IItemHandler dst, ItemFilter filter, PrimitiveIterator.OfInt visitOrder) {
        ItemHandlerExtractionQuery extractionQuery = new ItemHandlerExtractionQuery(src);
        ItemHandlerInsertionQuery insertionQuery = new ItemHandlerInsertionQuery(dst);
        while (visitOrder.hasNext()) {
            int leftover;
            ItemHandlerExtractionQuery.Extraction extraction = extractionQuery.extractFirst(filter, visitOrder);
            if (extraction.getExtracted().m_41619_()) {
                return false;
            }
            ItemHandlerInsertionQuery.Insertion insertion = insertionQuery.insert(extraction.getExtracted());
            int extracted = extraction.getExtracted().m_41613_();
            int inserted = extracted - (leftover = insertion.getLeftover().m_41613_());
            if (inserted == 0 || !extraction.commitAtMost(inserted)) continue;
            insertion.commit();
            extractionQuery.commit();
            insertionQuery.commit();
            return true;
        }
        return false;
    }

    public static ItemStack transferStack(ItemStack stack, IItemHandler dst, boolean simulate) {
        if (InventoryHintFlags.of(dst).has(InventoryHint.SUPPORTS_QUICK_INSERT)) {
            return dst.insertItem(-1, stack, simulate);
        }
        return ItemHandlerHelper.insertItem((IItemHandler)dst, (ItemStack)stack, (boolean)simulate);
    }

    public static ItemStack mergeCountUnchecked(ItemStack first, ItemStack second) {
        if (first.m_41619_()) {
            return second;
        }
        if (second.m_41619_()) {
            return first;
        }
        ItemStack result = first.m_41777_();
        result.m_41769_(second.m_41613_());
        return result;
    }
}

